Ext.data.JsonP.sol_common_ix_GenericDynKwl({"tagname":"class","name":"sol.common.ix.GenericDynKwl","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.GenericDynKwl.js","href":"lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.04.000"],"eloix":true,"requires":["sol.common.ix.DynKwlDatabaseIterator","sol.common.ix.DynKwlFindChildrenIterator","sol.common.ix.DynKwlSearchIterator"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"prepareFunctions","tagname":"property","owner":"sol.common.ix.GenericDynKwl","id":"property-prepareFunctions","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getFindInfo","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-getFindInfo","meta":{"private":true}},{"name":"getProvider","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-getProvider","meta":{}},{"name":"getRowData","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-getRowData","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-initialize","meta":{"private":true}},{"name":"loadConfig","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-loadConfig","meta":{"private":true}},{"name":"prepareConfig","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-prepareConfig","meta":{"private":true}},{"name":"translate","tagname":"method","owner":"sol.common.ix.GenericDynKwl","id":"method-translate","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.ix.GenericDynKwl","short_doc":"This implements generic keywordlist functionality. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.GenericDynKwl</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator' rel='sol.common.ix.DynKwlDatabaseIterator' class='docClass'>sol.common.ix.DynKwlDatabaseIterator</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlFindChildrenIterator' rel='sol.common.ix.DynKwlFindChildrenIterator' class='docClass'>sol.common.ix.DynKwlFindChildrenIterator</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlSearchIterator' rel='sol.common.ix.DynKwlSearchIterator' class='docClass'>sol.common.ix.DynKwlSearchIterator</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl' target='_blank'>lib_sol.common.ix.GenericDynKwl.js</a></div></pre><div class='doc-contents'><p>This implements generic keywordlist functionality.</p>\n\n<h1>Supported keywordlist types</h1>\n\n<table>\n<thead>\n<tr>\n<th style=\"text-align:left;\">Type</th>\n<th style=\"text-align:left;\">Used Iterator</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td style=\"text-align:left;\">DB</td>\n<td style=\"text-align:left;\">Database iterator</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">SEARCH</td>\n<td style=\"text-align:left;\">Search iterator</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">CHILDREN</td>\n<td style=\"text-align:left;\">Children iterator</td>\n</tr>\n</tbody>\n</table>\n\n\n<h1>Configuration</h1>\n\n<p>It is highly recommended to use the provided app to create/edit the configurations.</p>\n\n<p>Each configuration (regardless of the used iterator) has to contain the following properties:</p>\n\n<table>\n<thead>\n<tr>\n<th style=\"text-align:left;\">Property</th>\n<th style=\"text-align:left;\">Property type</th>\n<th style=\"text-align:left;\">Description</th>\n<th style=\"text-align:left;\">Note</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td style=\"text-align:left;\">type</td>\n<td style=\"text-align:left;\">String</td>\n<td style=\"text-align:left;\">The type used. See <code>Supported keywordlist types</code>.</td>\n<td></td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">translate</td>\n<td style=\"text-align:left;\">Boolean</td>\n<td style=\"text-align:left;\">Determines, if translation should be applied on the <code>header</code>, the <code>output</code> and <code>searchParams.message</code></td>\n<td style=\"text-align:left;\">Has to be <code>true</code>, if any of those contain translation keys.</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">title</td>\n<td style=\"text-align:left;\">String</td>\n<td style=\"text-align:left;\">The title of the returned table. Could be a fixed string or a translation key.</td>\n<td></td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">header</td>\n<td style=\"text-align:left;\">String[]</td>\n<td style=\"text-align:left;\">An array with the table headers. Could be a fixed strings or a translation keys.</td>\n<td style=\"text-align:left;\">Currently not supported in children iterator.</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">output</td>\n<td style=\"text-align:left;\">String[]</td>\n<td style=\"text-align:left;\">An array containing the output fields.</td>\n<td style=\"text-align:left;\">No prefix for index fields. <code>IX_MAP_</code> prefix for map fields. <code>IX_MAP_</code> prefix and <code>{i}</code> suffix for map fields inside a form table.</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">searchParams</td>\n<td style=\"text-align:left;\">Object[]</td>\n<td style=\"text-align:left;\">An array containing configuration for the search.</td>\n<td style=\"text-align:left;\">This uses the old syntax of the iterators. For better understanding the app should be used to create the configuration. Currently not supported in children iterator.</td>\n</tr>\n</tbody>\n</table>\n\n\n<p>There are additional configuration properties for each iterator type.</p>\n\n<h2>DB</h2>\n\n<table>\n<thead>\n<tr>\n<th style=\"text-align:left;\">Property</th>\n<th style=\"text-align:left;\">Property type</th>\n<th style=\"text-align:left;\">Description</th>\n<th style=\"text-align:left;\">Note</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td style=\"text-align:left;\">sqlQuery</td>\n<td style=\"text-align:left;\">String</td>\n<td style=\"text-align:left;\">The SQL query for the database.</td>\n<td style=\"text-align:left;\">Number of selected columns has to be the same as the number of <code>headers</code> and <code>output</code>. If the query contains <code>?</code> they will be replaced by evaluating the <code>searchParams</code>.</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">jdbc</td>\n<td style=\"text-align:left;\">String</td>\n<td style=\"text-align:left;\">The name of a ressource defined in the Tomcat <code>META-INF/context.xml</code>.</td>\n<td style=\"text-align:left;\">Optional. If not set, the query will be executed against the ELO database.</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">dbName</td>\n<td style=\"text-align:left;\">String</td>\n<td style=\"text-align:left;\">To use a devian schema.</td>\n<td style=\"text-align:left;\">Optional</td>\n</tr>\n</tbody>\n</table>\n\n\n<h2>SEARCH</h2>\n\n<table>\n<thead>\n<tr>\n<th style=\"text-align:left;\">Property</th>\n<th style=\"text-align:left;\">Property type</th>\n<th style=\"text-align:left;\">Description</th>\n<th style=\"text-align:left;\">Note</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td style=\"text-align:left;\">dataFields</td>\n<td style=\"text-align:left;\">String[]</td>\n<td style=\"text-align:left;\">The fields from the found Sord objects which will be mapped to the output fields.</td>\n<td style=\"text-align:left;\">Has to be of the same size as the <code>output</code> array. Only index fields are supported.</td>\n</tr>\n</tbody>\n</table>\n\n\n<h2>CHILDREN</h2>\n\n<table>\n<thead>\n<tr>\n<th style=\"text-align:left;\">Property</th>\n<th style=\"text-align:left;\">Property type</th>\n<th style=\"text-align:left;\">Description</th>\n<th style=\"text-align:left;\">Note</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td style=\"text-align:left;\">parantId</td>\n<td style=\"text-align:left;\">String</td>\n<td style=\"text-align:left;\">The start point for the children search.</td>\n<td style=\"text-align:left;\">Could be an arcpath, an objId or a guid.</td>\n</tr>\n</tbody>\n</table>\n\n\n<h1>How to</h1>\n\n<p>To implement a keywordlist using this generic class two things are necessary: a script and a configuration.\nThe script needs to be implemented, because the only way to configure a field with a dynamic keyword list, is the name of a script file.\nThe configuration will tell the generic class how to performe the queries and how the data should be returned.</p>\n\n<p>The script file has to contain the include for the <code>lib_Class</code> as well as the include for the <code>lib_sol.common.ix.GenericDynKwl</code>.</p>\n\n<p>The easiest way to include the configuration is directly as a JSON string in the script as a global variable <code>kwlConfigString</code>:</p>\n\n<pre><code>var kwlConfigString = '{ ... }'\n</code></pre>\n\n<p>A more convinient way to include the configuration is in a separate configuration file:</p>\n\n<pre><code>var configPath = \"/contract/Configuration/kwl.config\",\n    kwlName = \"Companies\";\n</code></pre>\n\n<p>The <code>kwl.config</code> has to be JSON containing the property <code>Companies</code> which holds the configuration for this keyword list.\nFor even more convinience there is an app to edit those configuration file.</p>\n      <p class='version-tag'>Version: <b>1.04.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-prepareFunctions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-property-prepareFunctions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-property-prepareFunctions' class='name expandable'>prepareFunctions</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Lookup object for the prepare functions for all supported iterators. ...</div><div class='long'><p>Lookup object for the prepare functions for all supported iterators.\nThese function prepare the iterator specific configuration and create the provider.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getFindInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-getFindInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-getFindInfo' class='name expandable'>getFindInfo</a>( <span class='pre'>filterList</span> ) : de.elo.ix.client.FindInfo<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Implements a find by type search that is filtered by ObjKeys. ...</div><div class='long'><p>Implements a find by type search that is filtered by ObjKeys.\nUsed for the 'DynKwlSearchIterator'.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filterList</span> : String[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.FindInfo</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getProvider' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-getProvider' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-getProvider' class='name expandable'>getProvider</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the kwl provider which was created during initialization. ...</div><div class='long'><p>Retrieves the kwl provider which was created during initialization.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRowData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-getRowData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-getRowData' class='name expandable'>getRowData</a>( <span class='pre'>sord</span> ) : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Basic implementation for search results. ...</div><div class='long'><p>Basic implementation for search results.\nThis returns the content of the sord index fields.\nUsed for the 'DynKwlSearchIterator'.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-loadConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-loadConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-loadConfig' class='name expandable'>loadConfig</a>( <span class='pre'>initConfigParam</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initializes the configuration. ...</div><div class='long'><p>Initializes the configuration. Either from <code>kwlConfigString</code>, a config file or the contructor parameter.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>initConfigParam</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-prepareConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-prepareConfig' class='name expandable'>prepareConfig</a>( <span class='pre'>config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initializes the provider config for all provider types. ...</div><div class='long'><p>Initializes the provider config for all provider types.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-translate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.GenericDynKwl'>sol.common.ix.GenericDynKwl</span><br/><a href='source/lib_sol.common.ix.GenericDynKwl.html#sol-common-ix-GenericDynKwl-method-translate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.GenericDynKwl-method-translate' class='name expandable'>translate</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Performs the translation if translate is set to true. ...</div><div class='long'><p>Performs the translation if <code>translate</code> is set to <code>true</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});